//util.cpp: Implements utiltiy routines used throughout code
#include "global.h"

HPEN blackPen=::CreatePen(PS_SOLID,1,RGB(0x00,0x00,0x00));
HPEN redPen=::CreatePen(PS_SOLID,1,RGB(0xff,0x00,0x00));
HPEN greenPen=::CreatePen(PS_SOLID,1,RGB(0x00,0xff,0x00));
HPEN bluePen=::CreatePen(PS_SOLID,1,RGB(0x00,0x00,0xff));

real realRand(void)//Return a random number on [0,1)
{
	return ((real)(rand()&0x7fFF))/0x7fFF;
}

point pointRand(real max)//Return random point on [-max/2,max/2)x[-max/2,max/2)
{
	return point(realRand()*max-max/2,realRand()*max-max/2);
}

bool probability(int percent)//Return true probability out of 100 tries
{
	return ((rand()&0x7fff)%100)<percent;
}

void screen::printFloat(point p,double f)
{
	char buf[100];
	sprintf(buf,"%.3f",f);
	printStr(p,buf);
}
void screen::printStr(point p,const char *str)
{
	int x,y;
	map(p,x,y);
	RECT r={0,0,10000,10000};
	r.left=x;
	r.top=y;
	::DrawText(dc,str,-1,&r,DT_NOCLIP);
}

coord lineDist(person &p,point t1,point t2,coord radius,point &hitPt)
{
	point a=t2;a.sub(t1);
	point b=p.c;b.sub(t1);
	coord c_len=a.dot(b)/a.mag();
	hitPt=a;
	hitPt.scale(c_len/a.mag());
	hitPt.add(t1);
	if (c_len<0.0) 
		//Off t1 edge-- return distance
		return ptDist(p.c,t1)-p.radius-radius;
	else if (c_len>a.mag())
		//Off t2 edge-- return distance
		return ptDist(p.c,t2)-p.radius-radius;
	else//Bounce off middle
		return ptDist(p.c,hitPt)-p.radius-radius;
}


//Return if line segments [A1,A2] and [B1,B2] intersect, and where.
bool intersects(point A1,point A2,point B1,point B2,point &intersection)
{
	real m;//Slope y=mx+b
	real a1,b1=-1.0,c1;//Numbers a1*x+b1*y+c1=0 for line A1-A2
	if (A1.x==A2.x)
	{//Vertical line
		a1=1;b1=0;c1=-A1.x;}
	else
	{//Not vertical
		m=(A1.y-A2.y)/(A1.x-A2.x);
		a1=m;
		c1=A1.y-m*A1.x;
	}

	real a2,b2=-1.0,c2;//Numbers for line B1-B2
	if (B1.x==B2.x)
	{//Vertical line
		a2=1;b2=0;c2=-B1.x;}
	else
	{//Not vertical
		m=(B1.y-B2.y)/(B1.x-B2.x);
		a2=m;
		c2=B1.y-m*B1.x;
	}

	real det=a1*b2-a2*b1;
	if (det==0)
		return false;//Lines are parallel
	det=1.0/det;
	//Compute intersection location
	real ix=(b1*c2-b2*c1)*det;
	real iy=(c1*a2-c2*a1)*det;
	intersection.x=ix;
	intersection.y=iy;

	real tmp;
#define swap(a,b) {tmp=a;a=b;b=tmp;}
	//Re-Order vertices for easier bounds-testing
	if (A1.x>A2.x) swap(A1.x,A2.x);
	if (B1.x>B2.x) swap(B1.x,B2.x);
	if (A1.y>A2.y) swap(A1.y,A2.y);
	if (B1.y>B2.y) swap(B1.y,B2.y);

	//Check bounds on intersection location
	if ((A1.x<=ix)&&(ix<=A2.x)&&
		(A1.y<=iy)&&(iy<=A2.y)&&
		(B1.x<=ix)&&(ix<=B2.x)&&
		(B1.y<=iy)&&(iy<=B2.y))
		return true;
	return false;
}
