//SquareFurniture: implements square furniture object methods
#include "global.h"

void squareFurniture::init(coord len,coord ht,coord x,coord y,coord theta)
{//Ignores theta (for now)
	len/=2;ht/=2;
	v[0].x=x-len;v[0].y=y-ht;
	v[1].x=x-len;v[1].y=y+ht;
	v[2].x=x+len;v[2].y=y+ht;
	v[3].x=x+len;v[3].y=y-ht;

	v[4]=v[0];
	c=v[0];
	c.add(v[2]);
	c.scale(0.5);
}

void squareFurniture::draw(screen &s)
{
	HPEN oldPen=(HPEN)::SelectObject(s.dc,pen());
	int x,y;
	s.map(v[0],x,y);
	::MoveToEx(s.dc,x,y,NULL);
	int i;
	for (i=1;i<5;i++)
	{
		s.map(v[i],x,y);
		::LineTo(s.dc,x,y);
	}
	::SelectObject(s.dc,oldPen);
}

coord squareFurniture::hits(person &p,point &hitPt)
{
	real minDist=1000000;
	int i;
	for (i=1;i<5;i++)
	{
		point thisHit;
		real thisDist=lineDist(p,v[i-1],v[i],0.0,thisHit);
		if (thisDist<minDist)
		{
			minDist=thisDist;
			hitPt=thisHit;
		}
	}
	return minDist;
}

bool squareFurniture::inWay(person *p,point dest,coord &dist)
//Does this object lie between the given person and their destination?
{
	point cross;
	if (intersects(p->c,dest,v[0],v[2],cross)||
		intersects(p->c,dest,v[1],v[3],cross))
	{
		dist=ptDist(p->c,cross);
		return true;
	} else
		return false;
}
point squareFurniture::reRoute(person *p,point dest)
//How should this person walk to get around this object to their destination?
{
	point cross;//Intersection nearest to p->c
	point cross1,cross2;
	bool c1=intersects(p->c,dest,v[0],v[2],cross1);
	bool c2=intersects(p->c,dest,v[1],v[3],cross2);
	if (c1&&c2)
	{//If they both intersected, we need to find the closer intersection.
		if (ptDist(p->c,cross1)<ptDist(p->c,cross2))
			cross=cross1;//Cross1 is closer to person
		else
			cross=cross2;//Cross2 is closer
	} else if (c1)
		cross=cross1;
	else if (c2)
		cross=cross2;

	point a=cross;a.sub(c);//a points from our center to intersection
	//Make "a" point from center to just outside us
	a.scale((ptDist(v[0],c)+p->radius)/a.mag());
	//Translate "a" back to global coordinates
	a.add(c);
	return a;
}
