//roundFurniture.cpp: implements roundFurniture object methods
#include "global.h"

void roundFurniture::draw(screen &s)
{
	int x,y;
	s.map(c,x,y);
	int del=(int)(radius*s.scaleX);
	HPEN oldPen=(HPEN)::SelectObject(s.dc,pen());
	::Ellipse(s.dc,x-del,y-del,x+del,y+del);
	::SelectObject(s.dc,oldPen);
}

coord roundFurniture::hits(person &p,point &hitPt)
{
	hitPt=c;
	//Intersecting disks is SO easy!
	//Distance between their edges is just
	//distance between centers minus radii
	return ptDist(p.c,c)-p.radius-radius;
}

bool roundFurniture::inWay(person *p,point dest,coord &dist)
//Does this object lie between the given person and their destination?
{
	point a=dest;a.sub(p->c);//a points from p to target
	point b=c;b.sub(p->c);//b points from p to our center
	point nearest=a;//Nearest point to our center on line p-dest
	nearest.scale(a.dot(b)/a.dot(a));
	if (a.dot(nearest)<0) 
		return false;//The nearest point is behind us already
	dist=nearest.mag();
	nearest.add(p->c);
	coord r=ptDist(c,nearest);
	
	if (r-radius-p->radius<0)//If person's path intersects us,
		return true;//we're in the way
	else
		return false;
}
point roundFurniture::reRoute(person *p,point dest)
//How should this person walk to get around this object to their destination?
{
	point a=dest;a.sub(p->c);//a points from p to target
	point b=c;b.sub(p->c);//b points from p to our center
	point nearest=a;//Nearest point to our center on line p-dest
	nearest.scale(a.dot(b)/a.dot(a));
	nearest.add(p->c);
	nearest.sub(c);//Nearest now points from c to closest approach
	nearest.scale((radius+p->radius)/nearest.mag());
	nearest.add(c);
	return nearest;
}
