//person.cpp: implements methods for person class
#include "global.h"

//A person is basically a piece of round furniture that moves
//This way, the hit detection code only need be written
//once.

HPEN person::pen(void)
{
	return redPen;
}
coord person::walkSpeed(disaster &d)
{
	return 4*d.dt;//People walk at 4.0 feet per second (always)
}

point person::getDestination(disaster &d)//Find nearest exit from given disaster
{
//If we were last stuck, flee the person we stuck to
	if (nStuck>0)
		return lastStuck;

//Check to see if we need a new exit
	if ((destExit!=NULL) //And we had an old destination
		&&((ptDist(c,lastDest)>4.0))//If we're still a ways from our old destination
		&& probability(98) //And this is most of the time
	  )
			return lastDest;//Keep old target (don't re-target)

//Find the nearest visible exit
	destExit=NULL;
	int exitNo;
	for (exitNo=0;exitNo<d.nexits;exitNo++)
	{
		anexit *e=d.exits[exitNo];
		if (d.isVisible(e->center(),c))
		//This exit is visible
			if ((destExit==NULL)||(e->iamBetter(destExit,c)))
			//This exit is better than the current best
				destExit=e;
	}
	
	if (destExit==NULL) //We didn't find any exits!
	//Head in a random direction (wander)
	{
		point dest=c;
		dest.add(pointRand(10.0));
		return dest;
	}
	else//We found a good exit
	{
		point dest=destExit->center();//First guess: head towards nearest exit
	//Make sure no furniture is in the way of the exit:
		coord nearest=10000000;
		hit *inWay=NULL;
		int i;
		//Find nearest furniture blocking our path (from c to dest)
		for (i=0;i<d.nhits;i++)
		{
			coord thisDist;
			if (d.hits[i]->inWay(this,dest,thisDist))
			{
				if (thisDist<nearest)
				{
					nearest=thisDist;
					inWay=d.hits[i];
				}
			}
		}
		//Find a way around this furniture:
		if (inWay!=NULL)
			dest=inWay->reRoute(this,dest);
		return dest;
	}
}

void person::advance_begin(disaster &d)//Flee the given disaster
{
	lastDest=getDestination(d);
	
	nStuck=0;
//We want to walk towards our destination
	walkDir=lastDest;
	walkDir.sub(c);//Walkdir points from us to our destination
	walkDir.scale(walkSpeed(d)/walkDir.mag());//Scale to correct speed

	int i;
	for (i=0;i<d.nhits;i++) hitTest(d.hits[i]);
	for (i=0;i<d.nwalls;i++) hitTest(d.walls[i]);
}

bool person::repelledAt(hit *h,point newPos,point &repulsion)
//Return the repulsion vector h delivers to us, if we are at newPos
{
	point hitPt;
	coord hitDist;//Distance between us and object h
	point oldC=c;

	//Pretend we've walked in this direction
	c=newPos;
	//See if we hit anything
	hitDist=h->hits(*this,hitPt);
	//Stop pretending
	c=oldC;
	
	if (hitDist>0) return false;//No hit would happen.
	
	repulsion=newPos;//Points from hitPt to c+walkDir, which should be 
			//away from the intersecting object's surface
	repulsion.sub(hitPt);
	repulsion.scale(-hitDist/repulsion.mag());
		//Make repulsion have length -hitDist
	
	return true;
	
}
bool person::hitTest(hit *h)
//Do we run into object h walking in this direction?
{
	point repulsion;
	point newPos=c;
	newPos.add(walkDir);//Imagine new position
	if (!repelledAt(h,newPos,repulsion)) return false;//No hit would happen.

//Otherwise, a hit would happen.  We need to scale the walk direction
//so we don't slam into this object
	repulsion.scale(1.0+realRand()*0.4);
	walkDir.add(repulsion);
	return true;
}
bool person::hitPeople(person *p)
//Do we run into person p walking in this direction?
{
	point newPos=c;
	newPos.add(walkDir);//Imagine new position

	//Find the distance between centers
	if (ptDist(newPos,p->c)-radius-p->radius>0) 
		return false;//No hit would happen.

//Otherwise, we'd run into this person
	walkDir=point(0,0);//Stop
	//Note that we're stuck
	nStuck++;
	//Head in a random direction
	lastStuck=pointRand(1.0);
	lastStuck.add(c);
	return true;//We hit them.
}

void person::advance_end(disaster &d)//Done advancing
{
	if (destExit!=NULL)
	{//Check to see how much progress we've made towards this exit
		point a=destExit->center();a.sub(c);
		point b=walkDir;
		totalProgress+=a.dot(b)/a.mag();
	}
	//Now that we know the right direction in which to walk, walk there!
	c.add(walkDir);//Teleport in this direction (no inertia)
}

bool person::at_exit(disaster &d)//Can we leave yet?
{
	if (destExit==NULL)
		return false;//No exit, even!
	if (destExit->canLeave(*this))
		return true;//We're saved!
	return false;//We can't leave yet...
}


void person::draw(screen &s)//Draw self on screen
{//Just call superclass
	roundFurniture::draw(s);
}

