//parser.cpp: Implements disaster::parse_input file
#include "global.h"


bool disaster::parse_input(const char *fName)
{
    double p1,p2,p3,p4,p5;
	int peoplePercent=100;
	double peopleRand=0.0;//Maximum random displacement of people

	if (fName==NULL||fName[0]==0) return false;
	FILE *out=fopen(fName,"r");
	if (out==NULL)
	{printf("Couldn't open input file '%s'!\n",fName);return false;}

	char buf[1024];
	int lineNo=1;
	while (NULL!=fgets(buf,1024,out))
	{
		char keyword[1024];
		strtok(buf,";");//Cut off comments
		keyword[0]=0;
		sscanf(buf,"%s",keyword);
		
		if (0==strcmp(keyword,"boundary"))
		{
			int dex=0,dist;
			int i = 0;
			double vals[200];
			sscanf(&buf[dex],"%s%n",keyword,&dist);
			dex+=dist;
			while (1==sscanf(&buf[dex],"%lf%n",&p1,&dist))
			{
				dex+=dist;
				vals[i++]=p1;
				if ((i>2)&&(i%2==0))
					(walls[nwalls++]=new wall)->
						init(point(vals[i-4],vals[i-3]),
							point(vals[i-2],vals[i-1]));
			}
		} else if (0==strcmp(keyword,"frectangle"))
		{
			if (5>sscanf(buf,"%s %lf %lf %lf %lf %lf",keyword,&p1,&p2,&p3,&p4,&p5))
			{printf("Syntax error on line %d!\n",lineNo);exit(1);}
			squareFurniture *f=new squareFurniture;
			f->init(p1,p2,p3,p4,p5);
			hits[nhits++]=f;
		}else if (0==strcmp(keyword,"fcircle"))
		{
			if (4!=sscanf(buf,"%s %lf %lf %lf",keyword,&p1,&p2,&p3))
			{printf("Syntax error on line %d!\n",lineNo);exit(1);}
			((roundFurniture *)(hits[nhits++]=new roundFurniture))
				->init(point(p1,p2),p3);
		}else if (0==strcmp(keyword,"peoplepercent"))
		{	
			if (2!=sscanf(buf,"%s %lf",keyword,&p1))
			{printf("Syntax error on line %d!\n",lineNo);exit(1);}
			peoplePercent=(int)p1;

		}else if (0==strcmp(keyword,"peoplerand"))
		{	
			if (2!=sscanf(buf,"%s %lf",keyword,&p1))
			{printf("Syntax error on line %d!\n",lineNo);exit(1);}
			peopleRand=p1;

		}else if (0==strcmp(keyword,"person"))
		{
			if (4!=sscanf(buf,"%s %lf %lf %lf",keyword,&p1,&p2,&p3))
			{printf("Syntax error on line %d!\n",lineNo);exit(1);}
			if (probability(peoplePercent))
				(people[npeople++]=new person)->
					init(point(p1+peopleRand*realRand(),p2+peopleRand*realRand()),p3);
		}else if (0==strcmp(keyword,"exitsign"))
		{
			p4=20.0;
			if (4>sscanf(buf,"%s %lf %lf %lf %lf",keyword,&p1,&p2,&p3,&p4))
			{printf("Syntax error on line %d!\n",lineNo);exit(1);}
			(exits[nexits++]=new anexit)->init(point(p1,p2),point(p1+1,p2+1),p3,p4);
		}  else if (0==strcmp(keyword,"exit"))
		{
			p5=20.0;
			if (5>sscanf(buf,"%s %lf %lf %lf %lf %lf",keyword,&p1,&p2,&p3,&p4,&p5))
			{printf("Syntax error on line %d!\n",lineNo);exit(1);}
			(exits[nexits++]=new anexit)->init(point(p1,p2),point(p3,p4),1.0,p5);
		} else if (buf[0]!=0)//Null strings OK
		{
			printf("Unrecognized string '%s' on line %d\n",buf,lineNo);
		}
		lineNo++;
    }
	return true;
}
