//main.cpp: controls user interface, maintains disaster object
#include "global.h"

extern LPSTR myCommandHack;
const static double zoomTable[6]={40.0,20.0,10.0,5.0,2.5};
void CApp::init(HWND Nwindow)
{
	strcpy(inFile,myCommandHack);
	window=Nwindow;
	d=new disaster;
	d->init(inFile);
	runFor=0;
	draws=1;
	zoom=zoomTable[2];
	running=false;
	leaveTrails=false;
}

bool CApp::paint(HDC dc)
{
	RECT r={0,0,10000,10000};
	screen s(dc,zoom,0,zoom,25);
	int i;
	for (i=0;i<draws;i++)
	{//Step draws number of times
		if (running)
			d->advance();
		if (runFor>0)
		{d->advance();runFor--;}
	}

	if (!leaveTrails)
		FillRect(dc,&r,(HBRUSH)GetStockObject(WHITE_BRUSH));
	d->draw(s);
	return (runFor>0)||(running);
}
void CApp::menu(int id)
{
	switch(id)
	{
	case MENU_STOP:
		runFor=0;
		running=false;
		break;
	case MENU_START:
		running=true;
		break;
	case  MENU_STEP:
		draws=1;
		runFor++;
		break;
	case  MENU_STEP10:
		draws=1;
		runFor+=10;
		break;
	case  MENU_STEP100:
		draws=10;
		runFor+=100;
		break;
	case  MENU_TRAILS:
		leaveTrails=true;
		break;
	case  MENU_NOTRAILS:
		leaveTrails=false;
		break;
	case MENU_RESET:
		delete d;
		d=new disaster;
		d->init(inFile);
		break;
	case MENU_ZOOM4:
	case MENU_ZOOM2:
	case MENU_ZOOM1:
	case MENU_ZOOMHALF:
	case MENU_ZOOMQUARTER:
		zoom=zoomTable[id-MENU_ZOOM];
		break;
	case MENU_1DRAW:	draws=1;break;
	case MENU_3DRAW:	draws=3;break;
	case MENU_10DRAW:	draws=10;break;
	case MENU_100DRAW:	draws=100;break;
	case MENU_1000DRAW:	draws=1000;break;
		break;
	}
	::InvalidateRect(window,NULL,false);//Redraw
}

void CApp::close(void)
{
	delete d;
}
