//grid.h: contains grid-related definitions

//GridCell: a 5x5 foot patch of ground.
//Keeps track of which people are in this cell.
class gridCell {
protected:
	int cur;
	person **people;int npeople;
public:
	gridCell();
	~gridCell();
	void init(int max);
	int num(void) {return npeople;}//Return number of people in list

	void add(person *p);//Add given person to list
	void clear(void){npeople=0;}//Set people-list to empty
	void reset(void){cur=0;}//Start listing people from people-list
	person *next(void);//Get next person in list
};


#define gridRes 5.0 /*Resolution of grid, in feet*/
class gridBag {
protected:
	int wid,ht;
	gridCell *cells;//Row-major list of grid cells, widxht.
	gridCell **curCells;//9-element list of nearby cells
	int curCell;//Current cell number
public:
	gridBag(int Nwid,int Nht,int max);
	~gridBag();
	
	void clear(void);//Set all people-lists to empty
	coord gridArea(void);//Return area of a grid cell (sq. feet)
	gridCell &getCell(point p);//Return grid cell for given location

	gridCell &setCur(point p);//Sets the current cell to that around p.
	person *next(void);//Get the next person near the current cell.

	int nCenter(void) {return wid*ht+1;}//Return number of grid cells
	point center(int num);//Return center of grid cell num
};
