//grid.cpp: implements all grid-related classes
#include "global.h"

/***************** GridCell Implementation******************/
gridCell::gridCell()
{
	people=NULL;cur=0;npeople=0;
}
gridCell::~gridCell()
{
	if (people!=NULL)
		delete [] people;
}
void gridCell::init(int max)
{
	people=new person*[max];
	npeople=0;
}

void gridCell::add(person *p)//Add given person to list
{people[npeople++]=p;}

person *gridCell::next(void)//Get next person in list
{
	if (cur<npeople)
		return people[cur++];
	else return NULL;
}

/******************** GridBag Implementation *************************/
gridBag::gridBag(int Nwid,int Nht,int max)
{
	wid=Nwid;ht=Nht;
	curCells=new gridCell*[9];
	cells=new gridCell[wid*ht+1];
	int x,y;
	for (y=0;y<ht;y++)
		for(x=0;x<wid;x++)
			cells[y*wid+x].init(max);
	cells[wid*ht].init(max);//Out-of-bounds cell
}
gridBag::~gridBag()
{
	delete [] cells;
	delete [] curCells;
}

void gridBag::clear(void)//Set all people-lists to empty
{
	int x,y;
	for (y=0;y<ht;y++)
		for(x=0;x<wid;x++)
			cells[y*wid+x].clear();
	cells[wid*ht].clear();//Out-of-bounds cell
}
coord gridBag::gridArea(void)//Return area of a grid cell (sq. feet)
{
	return gridRes*gridRes;
}
gridCell &gridBag::getCell(point p)//Return grid cell for given location
{
	if ((p.x<0)||(p.x>=gridRes*wid)||
		(p.y<0)||(p.y>=gridRes*ht))
		return cells[wid*ht];//Out-of-bounds!
	int x,y;
	x=(int)(p.x/gridRes);
	y=(int)(p.y/gridRes);
	return cells[wid*x+y];//In-bounds
}

gridCell &gridBag::setCur(point p)//Sets the current cell to that around p.
{
	int cellNo=0;
	int dx,dy;
	for (dy=-1;dy<=1;dy++)
	for (dx=-1;dx<=1;dx++)
	{
		point pNew(p.x+dx*gridRes,p.y+dy*gridRes);
		gridCell *g=&getCell(pNew);
		g->reset();
		curCells[cellNo++]=g;
	}
	curCell=0;
	return *curCells[4];//Return middle cell.
}
person *gridBag::next(void)//Get the next person near the current cell.
{
	person *p=NULL;
	do
	{
		if (curCell>=9)
			return NULL;
		p=curCells[curCell]->next();
		if (p!=NULL)
			return p;
		else
			curCell++;//Advance to next cell-- this one's empty
	} while (p==NULL);
	return NULL;//If we couldn't find one by now, none exists
}

point gridBag::center(int num)//Return center of grid cell num
{
	if (num==wid*ht)
		return point(-10,-10);//Out-of-bounds
	int x=num%wid,y=num/wid;
	return point(x*gridRes+gridRes/2,y*gridRes+gridRes/2);
}
