//exit.cpp: implements all Anexit class methods
#include "global.h"
void anexit::init(point Nt1,point Nt2,double Nstrength,double Ndiameter)
{
	t1=Nt1;t2=Nt2;
	myStrength=Nstrength;diameter=Ndiameter;
	myCenter=t1;
	myCenter.add(t2);
	myCenter.scale(0.5);
	radius=0;
}
void anexit::calcCongestion(disaster &d)
{//Calculate the congestion near the exit
	int dx,dy;
	int dist=(int)(diameter/gridRes);
	nFolks=0;

	for (dy=-dist;dy<=dist;dy++)
	for (dx=-dist;dx<=dist;dx++)
	{
		point p=point(myCenter.x+dx*gridRes,myCenter.y+dy*gridRes);
		nFolks+=d.grid->getCell(p).num();
	}
	nFolks;
	double floatFolks=nFolks/50;
	congestion=(floatFolks/(1+floatFolks));
}
double anexit::strength(point vantage)
{//Return the strength of this exit, viewed from vantage.
	double dist=ptDist(vantage,myCenter)/20.0;
	return myStrength-5*dist/(1+dist)-5*congestion;
}

bool anexit::iamBetter(anexit *other,point vantage)//Is this exit better than other?
{
	double disStrength=strength(vantage);
	double hisStrength=other->strength(vantage);
	return disStrength>hisStrength;
}

bool anexit::canLeave(person &p)//Can person p leave via this exit now?
{
	if (myStrength<0)
		return false;//This is just a warning sign, not an exit!
	point ignored;
	if (hits(p,ignored)<0)
		return true;//Person is penetrating exit-- let them leave
	else
		return false;//Person is not penetrating exit-- they stay.
}


void anexit::draw(screen &s)
{
	wall::draw(s);
	//s.printFloat(myCenter,congestion);
}
