//disaster.cpp: Implements all disaster methods except parse_input
#include "global.h"

void disaster::init(const char *fName)
{
	srand(1);//Seed the random number generator, so we get the same sequence
	dt=0.20;//Timestep in seconds
	time=0;
	log=fopen("exit_log.txt","w");
	log2=fopen("progress_log.txt","w");
	totalSaved=0;
	
	//Create the grid
	grid=new gridBag(30,30,50);
	
	//Create lists of objects
	walls=new wall*[max_objects];nwalls=0;
	exits=new anexit*[max_objects];nexits=0;
	hits=new hit*[max_objects];nhits=0;
	people=new person*[max_people];npeople=0;

	if (!parse_input(fName)&&!parse_input("test.txt"))
	{//If we couldn't open any input files
		//Hardcode objects to fill the lists 
		(walls[nwalls++]=new wall)->init(point(10,0),point(10,15));
		(walls[nwalls++]=new wall)->init(point(10,15),point(5,15));
		(exits[nexits++]=new anexit)->init(point(14,17),point(14,18),-1.0,20.0);
		(exits[nexits++]=new anexit)->init(point(5,15),point(5,20),1.0,20.0);
		(walls[nwalls++]=new wall)->init(point(5,20),point(10,20));
		(walls[nwalls++]=new wall)->init(point(10,20),point(10,100));
		//(exits[nexits++]=new anexit)->init(point(5,40),point(5,45),1.0,50.0);
		//((roundFurniture *)(hits[nhits++]=new roundFurniture))->
		//	init(point(40,35),6);
		((squareFurniture *)(hits[nhits++]=new squareFurniture))->
			init(3,8,40,25,0);
		//Allocate a bunch of people
		int x,y;
		for (x=55;x<85;x+=4)
		for (y=20;y<45;y+=4)
			((roundFurniture *)(people[npeople++]=new person))->
				init(point(x,y),1);
	}
}

disaster::~disaster()
{//Destructor
	if (log!=NULL) fclose(log);
	delete grid;
	int i;
	for (i=0;i<nwalls;i++) delete walls[i]; delete [] walls;
	for (i=0;i<nexits;i++) delete exits[i]; delete [] exits;
	for (i=0;i<nhits;i++) delete hits[i]; delete [] hits;
	for (i=0;i<npeople;i++) delete people[i]; delete [] people;
}

void disaster::advance(void)//Move objects around
{
	if (npeople>0)
		time++;//Increment the frame counter (time*dt=simulation time in seconds)
	
	int i,cell;
	//Clear each grid cell
	grid->clear();
	
	//Sift people into their grid cells
	for (i=0;i<npeople;i++)
	{
		person *p=people[i];
		gridCell *g=&(grid->getCell(p->c));
		g->add(p);
		p->cell=g;
	}
	
	//Update the exit congestion
	for (i=0;i<nexits;i++)
		exits[i]->calcCongestion(*this);
	
	//Perform human interactions: For each grid cell...
	for (cell=0;cell<grid->nCenter();cell++)
	{
		gridCell &center=grid->setCur(grid->center(cell));
		//Break if nobody's here
		if (center.num()==0) continue;

		//Make a list of people near the current cell
		person *nearPeople[200];int nNear=0;
		while (NULL!=(nearPeople[nNear]=grid->next()))
			nNear++;
		
		//For each person in this cell...
		center.reset();
		person *cur;//The person inside the current cell 
		while (NULL!=(cur=center.next()))
		{
			cur->advance_begin(*this);
			//Hit-test them against everybody nearby
			for (i=0;i<nNear;i++)
				if (cur!=nearPeople[i])
					cur->hitPeople(nearPeople[i]);
			cur->advance_end(*this);
		}
	}

	//Check to see if they're at an exit
	for (i=0;i<npeople;i++)
		if (people[i]->at_exit(*this))
		{//This person has reached an exit and is ready to leave
			totalSaved++;//Increment saved-counter
		    delete people[i];
			people[i]=people[--npeople];
			i--;
		}
	
	if ((time%5==0)||(npeople==0))
		saveLog();//Log every second
}

bool disaster::isVisible(point dest,point source)//Is dest visible from source?
{
	point cross;
	int i;
	for (i=0;i<nwalls;i++) 
		if (intersects(walls[i]->t1,walls[i]->t2,source,dest,cross))
			return false;//Line from source to dest hits wall
	return true;//If no wall obscures our vision, we can see dest.
}
void disaster::saveLog(void)
{//Write useful information to log files
	if (log==NULL) return;
	fprintf(log,"%.2f\t",time*dt);//Write time to log file
	fprintf(log,"%d\t",exits[0]->nFolks);//Write # of people around exit 0

	fprintf(log,"%d\t",totalSaved);//Write # of people saved
	
	fprintf(log,"\n");//Write end-of-line to log file
	fflush(log);

	if (log2==NULL) return;
	//Loop on the number of people in this cell
	int nPeople;
	for (nPeople=0;nPeople<10;nPeople++)
	{
		double ave=0;//Average amount of progress for these people
		int num=0;
		int i;
		for (i=0;i<npeople;i++)
			if (people[i]->cell->num()==nPeople)
			{
				ave+=people[i]->totalProgress-people[i]->lastProgress;
				people[i]->lastProgress=people[i]->totalProgress;
				num++;
			}
		fprintf(log2,"%d\t%.2f\t",num,ave/num);
	}
	fprintf(log2,"\n");
	fflush(log2);
}


void disaster::draw(screen &s)//Draw all objects (may be much slower than "advance()")
{
	//Draw frame counter
	char timeStr[100];
	RECT r={3,3,1000,1000};
	sprintf(timeStr,"%d.%02d s",(int)(time*dt),(int)(time*dt*100)%100);
	::DrawText(s.dc,timeStr,-1,&r,DT_NOCLIP);

	//Loop over each object type, calling its "draw" function
	int i;
	for (i=0;i<nwalls;i++) walls[i]->draw(s);
	for (i=0;i<nexits;i++) exits[i]->draw(s);
	for (i=0;i<nhits;i++) hits[i]->draw(s);
	for (i=0;i<npeople;i++) people[i]->draw(s);
}

