//app_main.cpp: maps Windows Message callbacks to CApp methods
#include <windows.h>
#include "menu_ids.h"
#include "app_main.h"

#include "std_main.h"
LRESULT DoCreateMain(HWND hWnd,UINT msg,WPARAM wParam,LPARAM lParam);
LRESULT DoPaintMain(HWND hWnd,UINT msg,WPARAM wParam,LPARAM lParam);
LRESULT DoDestroyMain(HWND hWnd,UINT msg,WPARAM wParam,LPARAM lParam);
LRESULT DoMenu(HWND hWnd,UINT msg,WPARAM wParam,LPARAM lParam);

const decodeUINT messageArr[]={
	WM_CREATE,DoCreateMain,
	WM_PAINT,DoPaintMain,
	WM_DESTROY,DoDestroyMain,
	WM_COMMAND,DoMenu
};
const int messageLen=sizeof(messageArr)/sizeof(messageArr[0]);

const TCHAR *winName=TEXT("MCM Project");
const int winWid=503,winHt=443;

CApp *app;

LRESULT DoCreateMain(HWND hWnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
	app=new CApp;
	app->init(hWnd);
	
	return 0;
}

LRESULT DoPaintMain(HWND hWnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
	PAINTSTRUCT paint;
	HDC crapDC=::BeginPaint(hWnd,&paint);
	::EndPaint(hWnd,&paint);
	
	HDC dc=::GetDC(hWnd);
	
	if (app->paint(dc))
		::InvalidateRect(hWnd,NULL,false);//for animation et. al
	::ReleaseDC(hWnd,dc);
	return 0;
}

LRESULT DoDestroyMain(HWND hWnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
	app->close();
	delete app;
	PostQuitMessage(0);
	return 0;
}


LRESULT DoMenu(HWND hWnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
	int wmId    = LOWORD(wParam); // Remember, these are... 
	int wmEvent = HIWORD(wParam); // ...different for Win32! 
	
	//Parse the menu selections: 
	switch (wmId) { 
	case MENU_EXIT: 
		DestroyWindow (hWnd); 
		PostQuitMessage(0);
		break;
	default:
		app->menu(wmId);
		break;
	}
	return 0;
}

