// Standardized Windows Main Routine
// mostly stolen from Doug Boling's "Programming Microsoft Windows CE"
//
// Orion Lawlor, 12/1998
#include "std_main.h"

const TCHAR g_szAppName[]=TEXT("LawlorStd");
HINSTANCE g_hInst;

LRESULT CALLBACK MainWndProc(HWND hWnd,UINT wMsg,WPARAM wParam,LPARAM lParam);
LRESULT CALLBACK MainWndProc(HWND hWnd,UINT wMsg,WPARAM wParam,LPARAM lParam)
{
	int i;
	for (i=0;i<messageLen;i++)
		if (wMsg==messageArr[i].Code)
			return messageArr[i].Fxn(hWnd,wMsg,wParam,lParam);
	return DefWindowProc(hWnd,wMsg,wParam,lParam);
}

void InitApp(HINSTANCE hInstance);
void InitApp(HINSTANCE hInstance)
{
	WNDCLASS wc;
	
	wc.style=0;
	wc.lpfnWndProc=MainWndProc;
	wc.cbClsExtra=0;
	wc.cbWndExtra=0;
	wc.hInstance=hInstance;
	wc.hIcon=LoadIcon(hInstance,"MAIN_ICON");
	wc.hCursor=LoadCursor(hInstance,"MAIN_CURSOR");
	wc.hbrBackground=(HBRUSH)GetStockObject(WHITE_BRUSH);
	wc.lpszMenuName=TEXT("LawlorMenu");
	wc.lpszClassName=g_szAppName;
	
	RegisterClass(&wc);
}

void InitInstance(HINSTANCE hInstance,int nCmdShow);
void InitInstance(HINSTANCE hInstance,int nCmdShow)
{
	HWND hWnd;
	g_hInst=hInstance;
#if WinCE
	int windowStyle=WS_VISIBLE;
#else
	int windowStyle=WS_BORDER+WS_OVERLAPPED+WS_VISIBLE+
				WS_MAXIMIZEBOX+WS_MINIMIZEBOX+WS_SYSMENU;
#endif
	hWnd=CreateWindow(g_szAppName,winName,windowStyle,
			CW_USEDEFAULT,CW_USEDEFAULT,winWid,winHt,
			NULL,NULL,g_hInst,NULL);
	ShowWindow(hWnd,nCmdShow);
	UpdateWindow(hWnd);
}

#if WinCE
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,LPWSTR lpCmdLine,int nCmdShow)
#else
int APIENTRY WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nCmdShow)
#endif
{
	MSG msg;
	if (hPrevInstance==NULL)
		InitApp(hInstance);
	InitInstance(hInstance,nCmdShow);
	while (GetMessage(&msg,NULL,0,0)) {
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	return msg.wParam;
}

