/*My Windows Microphone Wrapper Class.*/
#include "mic.h"

/*MicBuffer implementation:*/
void micBuffer::init(int Nlen,HWAVEIN hWave)
{
	len=Nlen;
	buf=(unsigned char *)malloc(sizeof(unsigned char)*len);
	micbuf.lpData=(LPSTR)buf;
	micbuf.dwBufferLength=len;
	micbuf.dwBytesRecorded=len;
	micbuf.dwUser=0;
	micbuf.dwFlags=0;
	micbuf.dwLoops=0;
	micbuf.lpNext=NULL;
	micbuf.reserved=0;
	waveInPrepareHeader(hWave,&micbuf,sizeof(micbuf));
	micbuf_flags=micbuf.dwFlags;
}

int micBuffer::isDone(void)
{
	int done=!!(micbuf.dwFlags|WHDR_DONE);
	if (micbuf.dwBytesRecorded==len)
		return done;
	else return 0;
}

MMRESULT micBuffer::addTo(HWAVEIN hWave)
{
	micbuf.dwFlags=micbuf_flags;
	micbuf.dwBytesRecorded=0;
	return waveInAddBuffer(hWave,&micbuf,sizeof(micbuf));
}


/*Microphone implementation.*/
void microphone::check(MMRESULT m)
{
	if (m!=MMSYSERR_NOERROR)
	{
		char buf[1000],errBuf[1000];
		waveOutGetErrorText(m,errBuf,1000);
		wsprintf(buf,
			"I'm sorry, but an audio-input error occurred.\n"
			"The number is %d; the system error message is:\n"
			"%s."
			,(int)m,errBuf);
		MessageBox(NULL,buf,"Error",MB_OK);
		exit(1);
	}
}

void microphone::init(void)
{
	WAVEFORMATEX form={WAVE_FORMAT_PCM,
		1,22050,0,1,8,0};
	MMRESULT m;
	m=waveInOpen(&hWave,WAVE_MAPPER,&form,
		NULL,0,CALLBACK_NULL+WAVE_ALLOWSYNC);
	if (m==MMSYSERR_NODRIVER||m==WAVERR_BADFORMAT)
		{MessageBox(NULL,"Could not open a 22 kHz 8-bit microphone.  "
			"This could be because you don't have a microphone, "
			"your sound card is misconfigured, or your sound card "
			"does not support 22 kHz 8-bit input.\n","Could not open mic",MB_OK);exit(1);}
	check(m);
}

void microphone::record(micBuffer *m)
{
	check(waveInStop(hWave));
	check(m->addTo(hWave));
	check(waveInStart(hWave));
}

void microphone::close(void)
{
	check(waveInReset(hWave));
	check(waveInClose(hWave));
}

HWAVEIN microphone::get(void)
{
	return hWave;
}
