#include "menu_ids.h"
#include "mic.h"
#include "audio.h"

class CApp
{
	HWND window;
#define BUFLEN 2048
#define nBUFS 3
		int curBuf;
		micBuffer recBuf[nBUFS];
		int nRedraws;
		microphone m;
		int currentKey;
		void selectKey(int newKey);
	public:
		void init(HWND Nwindow);
		void DoPaint(HDC dc);
		void menu(int menuId);
		void close(void);
};

void CApp::selectKey(int newKey)
{
	CheckMenuItem(GetMenu(window),
		MENU_KEYS+currentKey,
		MF_BYCOMMAND+MF_UNCHECKED);
	CheckMenuItem(GetMenu(window),
		MENU_KEYS+newKey,
		MF_BYCOMMAND+MF_CHECKED);
	currentKey=newKey;
}
void CApp::init(HWND Nwindow)
{
	window=Nwindow;
	nRedraws=0;
	curBuf=0;
	m.init();
	int i;
	for (i=0;i<nBUFS;i++)
		recBuf[i].init(BUFLEN,m.get());
	currentKey=0;
	selectKey(0);
}

void CApp::DoPaint(HDC dc)
{
	if (recBuf[curBuf].isDone())
	{/*Recording done (or never started).  Re-submit buffer.*/
		int next=curBuf+1;
		if (next>=nBUFS) next=0;
		m.record(&recBuf[next]);
		//erase(dc);
		//drawBuf(dc,&recBuf[curBuf]);
		//markCrossings(dc,&recBuf[curBuf]);
		//fftMark(dc,&recBuf[curBuf]);
		fftDraw(dc,&recBuf[curBuf],currentKey);
		curBuf=next;
		nRedraws++;
	}
}
void CApp::menu(int id)
{
	if (id>=MENU_KEYS&&id<MENU_KEYS+12)
		selectKey(id-MENU_KEYS);
}

void CApp::close(void)
{
	m.close();
}



#include "std_main.h"
LRESULT DoCreateMain(HWND hWnd,UINT msg,WPARAM wParam,LPARAM lParam);
LRESULT DoPaintMain(HWND hWnd,UINT msg,WPARAM wParam,LPARAM lParam);
LRESULT DoDestroyMain(HWND hWnd,UINT msg,WPARAM wParam,LPARAM lParam);
LRESULT DoMenu(HWND hWnd,UINT msg,WPARAM wParam,LPARAM lParam);

const decodeUINT messageArr[]={
	WM_CREATE,DoCreateMain,
	WM_PAINT,DoPaintMain,
	WM_DESTROY,DoDestroyMain,
	WM_COMMAND,DoMenu
};
const int messageLen=sizeof(messageArr)/sizeof(messageArr[0]);

const TCHAR *winName=TEXT("Lawlor Audio Input");
const int winWid=201,winHt=240;

CApp *app;
extern HBITMAP music_background;

LRESULT DoCreateMain(HWND hWnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
	app=new CApp;
	app->init(hWnd);
	
	music_background=LoadBitmap(g_hInst,"MUSIC_BITMAP");
	
	return 0;
}

LRESULT DoPaintMain(HWND hWnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
	PAINTSTRUCT paint;
	HDC crapDC=::BeginPaint(hWnd,&paint);
	::EndPaint(hWnd,&paint);
	
	HDC dc=::GetDC(hWnd);
	
	app->DoPaint(dc);
	
	::InvalidateRect(hWnd,NULL,false);//for animation et. al
	::ReleaseDC(hWnd,dc);
	return 0;
}

LRESULT DoDestroyMain(HWND hWnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
	app->close();
	delete app;
	PostQuitMessage(0);
	return 0;
}


LRESULT DoMenu(HWND hWnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
	int wmId    = LOWORD(wParam); // Remember, these are... 
	int wmEvent = HIWORD(wParam); // ...different for Win32! 
	
	//Parse the menu selections: 
	switch (wmId) { 
	case MENU_EXIT: 
		DestroyWindow (hWnd); 
		PostQuitMessage(0);
		break;
	default:
		app->menu(wmId);
		break;
	}
	return 0;
}

