#include <math.h>
#include "audio.h"

extern "C" {
#include "fft.h"
};

double findPeak(float *amp,int len)
{
	int i;
	float maxAmp=-10000000;
	int maxDex=0;
	for (i=0;i<len;i++)
		if (maxAmp<amp[i])
		{
			maxAmp=amp[i];
			maxDex=i;
		}
	if (maxDex==0||maxDex==len-1)
		return maxDex;
	float a,b,c,d;
	a=amp[maxDex-1];
	b=amp[maxDex];
	c=amp[maxDex+1];
	d=4*((a+c)/2-b);
	if (d!=0)
		return maxDex+(a-c)/d;
	else 
		return maxDex;
}

float getFreqency(unsigned char *Nbuf,int Nlen)
{
	unsigned char *buf=Nbuf;
	int len=Nlen,m=(int)(log(Nlen)/log(2.0)+0.5);
	int i;
	
	float fbuf[4096],dB[4096];
	float logScale=10.0/log(10.0);

/*Copy into float buffer.*/
	for (i=0;i<len;i++)
		fbuf[i]=buf[i]-128;
	
/*Do FFT*/
	fftInit(m);
	rffts(fbuf,m,1);

/*Compute decibel signal power in each frequency band.*/
	dB[0]=0;
	for (i=1;i<len/2;i++)
	{
		float real=fbuf[i*2],imag=fbuf[i*2+1];
		dB[i]=logScale*log(real*real+imag*imag);
	}

/*Find peak spectral power.*/
	float maxDex=findPeak(dB,len);
	return 22050.0*maxDex/len;/*Maximum frequency, in Hz*/
}
