#include "audio.h"

void drawDot(HDC dc,int x,int y)
{
	const int dotWidth=4;
	HPEN oldPen=(HPEN)SelectObject(dc,
		CreatePen(PS_SOLID,dotWidth,RGB(0x0ff,0x000,0x000))
		);

	x-=dotWidth/2;y-=dotWidth/2;
	MoveToEx(dc,x,y,NULL);
	LineTo(dc,x,y);
	
	DeleteObject(SelectObject(dc,oldPen));
}
void markCrossings(HDC dc,micBuffer *nbuf)
{
	unsigned char *buf=nbuf->buf;
	int len=nbuf->len;
	int i;
	const int midWay=128;
	int isNeg=buf[0]<midWay;
	for (i=0;i<len;i++)
	{
		int newNeg=buf[i]<midWay;
		if (newNeg!=isNeg)
			drawDot(dc,i,midWay);
		isNeg=newNeg;
	}
}

void erase(HDC dc)
{
	HBRUSH oldBrush=(HBRUSH)SelectObject(dc,CreateSolidBrush(RGB(255,255,255)));
	Rectangle(dc,0,0,10000,10000);
	DeleteObject(SelectObject(dc,oldBrush));
}

void drawBuf(HDC dc,micBuffer *buf)
{
	int i;
	
	MoveToEx(dc,0,buf->buf[0],NULL);
	for (i=0;i<buf->len;i++)
		LineTo(dc,i,buf->buf[i]);
}
