#include <math.h>
#include "audio.h"

/*Return number of half-steps for given tone in hz.*/
float hz2half(float hz);
float hz2half(float hz)
{
	return 12.0*log(hz)/log(2.0);
}

/*Convert tone's frequency (hz) into
number of half-steps (halfs),
nearest half-step (halfNo),
and mistuning in half-steps (tune)*/
void freq2halfTune(float hz,float *halfs,int *halfNo,float *tune);
void freq2halfTune(float hz,float *halfs,int *halfNo,float *tune)
{
	float halfCont=hz2half(hz)-hz2half(440.0);
	*halfNo=(int)floor(halfCont+0.5);/*Pitch number, in concert pitch.*/
	*tune=halfCont-*halfNo;/*Mistuning, in half-steps.*/
	*halfs=fmod(halfCont+1200,12.0);
	*halfNo=(1200+*halfNo)%12;
}

/*Displays the musical tone associated
with the given freqency, in Hz; transposed
by the given number of half steps.*/
char * printFreq(float hz,int transSteps);
char * printFreq(float hz,int transSteps)
{
	int halfNo;
	float halfs,delta;
	freq2halfTune(hz,&halfs,&halfNo,&delta);
	const char *semiNames[12]=
		{"A","Bb","B","C","C#","D","Eb","E","F","F#","G","Ab"};
	char *outBuf,*dist;
	int circPitch=(halfNo+transSteps)%12;/*pitch number, mod 12*/
	if (delta<0)
		dist="flat";
	else
		dist="sharp";
	outBuf=(char *)malloc(1000);
	sprintf(outBuf,"%.1f Hz-- %s   %.2f steps %s",
			hz,semiNames[circPitch],fabs(delta),dist);
	return outBuf;
}

void fftSquiggle(HDC dc,micBuffer *nbuf)
{
	char *mess=printFreq(getFreqency(nbuf->buf,nbuf->len),0);
	TextOut(dc,0,0,mess,strlen(mess));
	free(mess);
}

#ifndef PI
# define PI 3.14159265358979323
#endif

void copyPix(HBITMAP srcBits,HDC destDc,int destX,destY);
void copyPix(HBITMAP srcBits,HDC destDc,int destX,destY)
{
	BITMAP bmp;
	HDC memDc=CreateCompatibleDC(destDc);
	HBITMAP origBits=(HBITMAP)SelectObject(memDc,
		srcBits);
	GetObject(srcBits,sizeof(bmp),&bmp);
	BitBlt(destDc,destX,destY,bmp.bmWidth,bmp.bmHeight,
		memDc,0,0,SRCCOPY);
	
	SelectObject(memDc,origBits);
	DeleteDC(memDc);
}

void polarLine(HDC dc,double ang,double r1,double r2,int cx,int cy);
void polarLine(HDC dc,double ang,double r1,double r2,int cx,int cy)
{
	double cosAng=cos(ang);
	double sinAng=sin(ang);
	HPEN oldPen=(HPEN)SelectObject(dc,
		CreatePen(PS_SOLID,3,RGB(0x0ff,0x000,0x000))
		);
	
	MoveToEx(dc,cx+r1*cosAng,cy-r1*sinAng,NULL);
	LineTo(dc,cx+r2*cosAng,cy-r2*sinAng);
	
	DeleteObject(SelectObject(dc,oldPen));
}


HBITMAP music_background;
void fftDraw(HDC dc,micBuffer *nbuf,int concertKey)
{
	int halfNo;
	float halfs,delta;
	freq2halfTune(getFreqency(nbuf->buf,nbuf->len),&halfs,&halfNo,&delta);
	int cx=100,cy=100;
	halfs-=concertKey;/*This may need to be a +=... I don't remember the definition of tuning direction. */
	copyPix(music_background,dc,0,0);
	polarLine(dc,PI/2-2*PI*delta, 
		3,53,cx,cy);
	polarLine(dc,PI/2-2*PI*halfs/12.0,
		61,95,cx,cy);
}


