/*
Very very simple GLUT program without any libraries.

Orion Sky Lawlor, olawlor@acm.org, 2005/1/27 (Public Domain)
*/
#include <GL/glut.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>

/*********** OpenGL Camera Definition ********/
/* Updates the MODELVIEW matrix with the current camera location. */
void cameraChanged(void) {
	glLoadIdentity(); /* because gluPersepctive adds to current matrix */
	gluLookAt(0,0,5, /* camera location */
		0,0,0, /* target location (looking at here) */
		0,1,0); /* up vector */
	glutPostRedisplay(); /* ask GLUT to redraw our display */
}

void reshapeFn(int w, int h) /* Called by GLUT when window is resized */
{
	/* GL_PROJECTION matrix contains only the camera parameters */
	glViewport(0, 0, (GLsizei)w, (GLsizei)h);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity(); /* because gluPerspective combines with the current matrix */
	double z_near=1.0e-3,z_far=1.0e5; /* z buffer range */
	gluPerspective(70.0, w/(double)h, z_near,z_far);
	
	/* GL_MODELVIEW contains the world->camera transform */
	glMatrixMode(GL_MODELVIEW);
	cameraChanged();
}


/************ Crappy Keyboard User Interface **************/
int oglToggles[256]; /* initially 0; corresponding keyboard press toggles to 1 */
void keyboardFn(unsigned char key, int x, int y) /* Called by GLUT when a key is pressed */
{
	switch (key) {
	case 27: case 'x': case 'q': /*  Escape or quit key  */
		exit(0);
		break;
	default: /* all other keys just toggle the corresponding "keys" entry */
		oglToggles[key]=!oglToggles[key]; 
		break;
	}
	glutPostRedisplay(); /* ask GLUT to redraw our display */
}

/************ Main Drawing Function **************/
void displayFn(void) /* Called by GLUT to show every frame */
{
	glClear(GL_COLOR_BUFFER_BIT+GL_DEPTH_BUFFER_BIT); /* clears to background color */

	double radius=1.0;
	if (oglToggles['b']) radius=2.0; /* sphere is big */
	glColor3f(1,0,0); /* one red sphere */
	glutSolidSphere(radius,40,60);
	
	glutSwapBuffers(); /* displays rendered image */
}


/******** Program Initialization *********/
int main(int argc, char** argv)
{
/* Do GLUT initialization */
	glutInit(&argc, argv);
	glutInitDisplayMode (GLUT_DOUBLE | GLUT_DEPTH | GLUT_RGBA);
	glutInitWindowSize (1000, 700);
	glutCreateWindow (argv[0]); /* could also do glutEnterGameMode for fullscreen */

/* Do basic OpenGL initialization */
	glEnable(GL_DEPTH_TEST);
	glClearColor (0.0, 0.0, 0.0, 0.0); /* sets background color (RGBA) */

/* Set up GLUT GUI routines */
	glutDisplayFunc (displayFn);
	glutReshapeFunc (reshapeFn);
	glutKeyboardFunc (keyboardFn);
	
	/* Run the user interface until exit.  This call never returns. */
	glutMainLoop();
	return 0;
}
