/*
Depth and stencil buffer readback and display.

Orion Sky Lawlor, olawlor@acm.org, 2005/02/21 (Public Domain)
*/
#ifndef __OSL_READBACK_H
#define __OSL_READBACK_H

#include "ogl/util.h"

/**
  Provides operations to support reading depth or
  stencil from the screen, and splatting it back onscreen.
*/
class oglReadback {
	// In-memory buffer to hold the read-back data.
	char *buf; int buflen; 
	int wid,ht;
	typedef enum {depth,stencil} buftype;
	buftype type;
	GLenum datatype;
	
	// Texture used to display the read-back data.
	oglTexture *tex;
	int tex_wid,tex_ht; buftype tex_type;
	
	// Perform a readback.
	void read(int x,int y,int wid,int ht,buftype t);
	
public:
	oglReadback() {tex=0; buf=0; buflen=0; wid=ht=0; tex_wid=tex_ht=0;}
	~oglReadback() {delete tex; delete[] buf; buflen=-1;}
	
	/** Read back this portion of the stencil buffer */
	void readStencil(int x,int y,int wid,int ht)
		{read(x,y,wid,ht,stencil);}
	/** Read back this portion of the depth buffer */
	void readDepth(int x,int y,int wid,int ht)
		{read(x,y,wid,ht,depth);}
	
	/** After a readback, return the read data. 
	  Stencil data is 8-bit per pixel; depth is 16-bit per pixel.
	*/
	const void *getData(void) const {return buf;}
	
	/** After a readback, return a texture to display the data. */
	oglTexture *getTex(void);
	
	/** Display read-back data onscreen with the default mapping. */
	void show(void);
};


#endif
