/*
GL_ARB_fragment_program (or GL_ARB_vertex_program) per-pixel
or per-vertex program bindings.

Orion Sky Lawlor, olawlor@acm.org, 2005/2/17 (Public Domain)
*/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "ogl/program.h"

void oglProgram::make(int target_)
{
	if (!GLEW_ARB_fragment_program) {
		printf("oglProgram> You need programmable graphics hardware (ARBfp1.0) to run this program!\n");
		exit(1);
	}
	target=target_;
	glGenProgramsARB(1, &progName);
	bind();
}

void oglProgram::read(const char *fName) {
	
	// Read program from file (FIXME: what if program is longer than 65K?)
	int len=65536;
	char *s=new char[len];
	FILE *f=fopen(fName,"r");
	len=fread(s,1,len,f); // reset len to file length
	s[len]=0; // null terminate string
	fclose(f);
	
	// Upload program to graphics card
	set(s);
	
	delete[] s;
}
	
void oglProgram::set(const char *programText) {
	bind();
	glProgramStringARB(target, GL_PROGRAM_FORMAT_ASCII_ARB, 
		strlen(programText), programText);
	oglCheck(programText);
}

