/**
 A 4-float vector type suspiciously similar to GLSL's "vec4".
 
 Orion Sky Lawlor, olawlor@acm.org, 2006/09/12 (Public Domain)
*/
#ifndef __OSL_VEC4_H
#define __OSL_VEC4_H

#include <osl/vector4d.h>
typedef osl::Vector4dT<float> vec4;
inline vec4 normalize(const vec4 &v) {return v.dir();}
inline float dot(const vec4 &a,const vec4 &b) {return a.dot(b);}
inline float length(const vec4 &a) {return a.mag();}

#include <osl/vector3d.h>
typedef osl::Vector3dT<float> vec3;
inline vec3 normalize(const vec3 &v) {return v.dir();}
inline float dot(const vec3 &a,const vec3 &b) {return a.dot(b);}
inline float length(const vec3 &a) {return a.mag();}

/* that's all you need! */

#endif
