/*
A GLUT program using GLSL.

Orion Sky Lawlor, olawlor@acm.org, 2007/01/18 (Public Domain)
*/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>

#include <GL/glew.h> /* GL Extensions Wrangler, http://glew.sourceforge.net/ */
#include <GL/glut.h> /* GL Utilities Toolkit, http://freeglut.sourceforge.net/ */
#include <GL/glui.h> /* GL User Interface, http://glui.sourceforge.net/ */
#include "osl/vec4.h" /* GLSL-style C++ types, by Orion Lawlor */
#include "osl/mat4.h"
using osl::mat4;

#include "ogl/program.h"
#include "ogl/program.cpp"
#include "ogl/util.cpp"
#include "ogl/fast_mipmaps.c"

#ifndef M_PI
# define M_PI           3.14159265358979323846  /* pi */
#endif

/* Variables updated by the GUI */
float zoom=1.0, specExp=100.0;
int win_w, win_h; /**< Width and height (in pixels) of our window at last resize */

/* These are rotation matrices, updated by the GLUI_Rotation spheres */
mat4 modelMat(1.0), viewMat(1.0), light1Mat(1.0);



void Exit(const char *where,const char *why) {
	fprintf (stderr, "FATALITY: OpenGL Error in %s: %s\n", where, why);
	abort();	
}

// Check GL for errors after the last command
void Check(const char *where) {
	GLenum e=glGetError();
	if (e==GL_NO_ERROR) return;
	const GLubyte *errString = gluErrorString(e);
	Exit(where, (const char *)errString);
}


/* GLUT calls this routine every time our window needs to be redrawn */
void main_display(void) {
	// Clear the color and depth buffers
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT); /* actually clear color and depth */
	
	/* Depth testing */
	glEnable(GL_DEPTH_TEST);
	
	/* Alpha blending */
	glEnable(GL_BLEND);
	           /*  src color  + dest color  */
	glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
	
	// Load the model matrix into OpenGL
	glLoadMatrixf(&viewMat[0][0]);
	//glMultMatrixf(&modelMat[0][0]);
	
	glColor4f(1,1,0,1); /* yellow */
	glutSolidTorus(0.2,0.5,40,60);
	
	glColor4f(0,0,1,1); /* blue */
	glutSolidSphere(0.2,40,60);
	
	// Display the stuff drawn so far to the screen:
	glutSwapBuffers();
	
	
	/* This line causes the world to repeatedly redraw itself, using 100% of the CPU. */
	glutPostRedisplay();
}

/* GLUT calls this routine every time our window changes size */
void main_reshape(int w, int h) {
	win_w=w; win_h=h;
	glViewport(0, 0, (GLsizei)win_w, (GLsizei)(win_h));
}

void main_motion(int x,int y) {
	printf("Mouse is at %d, %d\n",x,y);
}

int main(int argc, char** argv)
{
	glutInitWindowSize(800,600);
	glutInit(&argc,argv);

	// Ask for a back buffer, color buffer, and Z buffer in a window.
	int mode=GLUT_DOUBLE | GLUT_RGBA | GLUT_DEPTH;
	glutInitDisplayMode (mode);
	int main_window = glutCreateWindow("GLSL Lighting Demo");

	// Ask GLUT to call us when we need to redraw
	glutDisplayFunc (main_display);
	glutReshapeFunc (main_reshape);
	glutMotionFunc  (main_motion);
	
	
	// Make some sliders (this is the only GLUI code you'll need!)
	GLUI *glui = GLUI_Master.create_glui_subwindow(main_window, 
		GLUI_SUBWINDOW_TOP);

	GLUI_Spinner *spin_zoom = new GLUI_Spinner( glui, "Zoom:", &zoom);
	spin_zoom->set_float_limits(0.0, 10.0);
	GLUI_Spinner *spin_spec = new GLUI_Spinner( glui, "SpecExp:", &specExp);
	spin_spec->set_float_limits(0.0, 1000.0);
	
	new GLUI_Column(glui);
	new GLUI_Rotation(glui,"Model:",&modelMat[0][0]);
	new GLUI_Column(glui,false);
	new GLUI_Rotation(glui,"View:",&viewMat[0][0]);
	new GLUI_Column(glui,false);
	new GLUI_Rotation(glui,"Light:",&light1Mat[0][0]);
	
	// Process events until user closes our window...
	glutMainLoop();
	
	return 0;
}
