/*
A GLUT program NOT using GLSL, 

Orion Sky Lawlor, olawlor@acm.org, 2007/01/18 (Public Domain)
*/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>

#include <GL/glut.h> /* GL Utilities Toolkit, http://freeglut.sourceforge.net/ */

int win_w, win_h;

/* GLUT calls this routine every time our window needs to be redrawn */
void main_display(void) {
	// Clear the color and depth buffers
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	
	glColor4f(1,1,0,0.3); /* yellow */
	glutSolidTorus(0.2,0.5,40,60);
	
	// Display the stuff drawn so far to the screen:
	glutSwapBuffers();
}

/* GLUT calls this routine every time our window changes size */
void main_reshape(int w, int h) {
	win_w=w; win_h=h;
	glViewport(0, 0, (GLsizei)win_w, (GLsizei)(win_h));
}

int main(int argc, char** argv)
{
	glutInitWindowSize(800,600);
	glutInit(&argc,argv);

	// Ask for a back buffer, color buffer, and Z buffer in a window.
	int mode=GLUT_DOUBLE | GLUT_RGBA | GLUT_DEPTH;
	glutInitDisplayMode (mode);
	int main_window = glutCreateWindow("GLSL Lighting Demo");

	// Ask GLUT to call us when we need to redraw
	glutDisplayFunc (main_display);
	glutReshapeFunc (main_reshape);
	
	// Process events until user closes our window...
	glutMainLoop();
	
	return 0;
}
