/**
Very simple web server.
This version serves only one client at a time.

Orion Sky Lawlor, olawlor@acm.org, 2005/2/8 (Public Domain)
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "osl/socket.h"
#include "osl/socket.cpp" /* include body for easy linking */

/* Convert integer to string */
std::string int_to_string(int i) {
	char buf[100]; sprintf(buf,"%d",i); return buf;
}

void serve_client(SERVER_SOCKET server_fd)
{
// Connect with the client
	skt_ip_t client_ip; unsigned int client_port;
	SOCKET s=skt_accept(server_fd,&client_ip,&client_port);
	char client_ip_name[200];
	printf("Connection received from %s:%d\n",
		skt_print_ip(client_ip_name,client_ip),client_port);
	
// Receive the client's request up to the first newline.
	//  This looks like "GET /some/url HTTP/1.1"
	std::string req=skt_recv_line(s);
	std::string options="";
	while (1) {
		std::string in=skt_recv_line(s);
		if (in.size()==0) break;
		else options+=in+"\n";
	}
	printf("Client request: %s\n",req.c_str());
	
	// Respond to the client's request, by sending him a web page.
	std::string headers= /* HTTP headers, less Content-Length */
		"HTTP/1.0 200 OK\n"
		"Content-Type: text/html\n";
	
	std::string webPage=
	"<html><title>Foo.</title><body>\n"
	"You asked for:\n"
	"<pre>"+req+"</pre>\n"
	"with options:\n"
	"<pre>"+options+"</pre>\n"
	"But this crappy page is all you're getting in return.\n"
	"</body></html>\n\n";
	
	
	std::string resp=headers+"Content-Length: "+int_to_string(webPage.size())+"\n\n"+webPage;
	skt_sendN(s,resp.c_str(),resp.size());
	
	// Close the client socket
	skt_close(s);
}

int main(int argc,char *argv[])
{
	unsigned int port=1234;
	SERVER_SOCKET server_fd;
	skt_init();
	server_fd=skt_server(&port);
	while (1) {
		printf("\nWaiting for connect on port %d\n",port);
		// Wait for a client to connect
		skt_select1(server_fd,0);
		// Serve this client
		serve_client(server_fd);
	}
	return 0;
}

