/**
Very simple network client: connects to localhost:1234,
receives a few bytes, and leaves.

Orion Sky Lawlor, olawlor@acm.org, 2005/2/8 (Public Domain)
*/
#include <stdio.h>
#include "osl/socket.h"
#include "osl/socket.cpp" /* include body for easy linking */

/* A message is always exactly this long */
#define MESSAGE_LEN 32

/* Paranoia routine: make sure "src" consists only of 
acceptable characters before parsing.  Output gets copied 
to "dest", which can equal "src" because dest moves slower
than src.
*/
void clean_message(const char *src,char *dest) {
	for (int i=0;i<MESSAGE_LEN;i++) {
		char c=*src++; /* grab next character of src */
		if (c==0) break; /* end of message */
		if ('A'<=c && c<='Z') *dest++=c; /* uppercase OK */
		if ('a'<=c && c<='z') *dest++=c; /* lowercase OK */
		if ( 0 <=c && c<= 9 ) *dest++=c; /* numbers OK */
		if (c==' ' || c=='\t') *dest++=c; /* spaces are OK */
		/* everything else gets dropped */
	}
	*dest++=0; /* always nul-terminate buffer */
}

void print_message(const char *src) {
	char cleaned[MESSAGE_LEN+1];  /* +1 because we might add nul termination */
	clean_message(src,cleaned);
	printf("Message received: '%s'\n",cleaned);
}

void grab_message(SOCKET s) {
	char msg[MESSAGE_LEN];
	skt_recvN(s,msg,MESSAGE_LEN); 
	print_message(msg);
}

int main(int argc,char *argv[])
{
	skt_ip_t ip=skt_lookup_ip("localhost");
	SOCKET s=skt_connect(ip,1234,60); 
	grab_message(s);
	skt_close(s); 
	printf("Program exiting.\n");
	return 0;
}
