/**
Two-pass communication network server.

Orion Sky Lawlor, olawlor@acm.org, 2006/1/22 (Public Domain)
*/
#include <stdio.h>
#include "osl/socket.h"
#include "osl/socket.cpp" /* include body for easy linking */

int main(int argc,char *argv[])
{
	char *buf;
	unsigned int port=1234; /* use 0 to have OS pick a port */
	SERVER_SOCKET serv=skt_server(&port);
	skt_ip_t client_ip; unsigned int client_port;
	SOCKET s=skt_accept(serv,&client_ip,&client_port);
	
	/* First pass: receive the length of the message */
	Big32 len;
	skt_recvN(s,&len,sizeof(len));
	printf("Client will send %d bytes of data\n",(int)len);
	
	/* Second pass: receive the message itself */
	buf=new char[len+1];
	skt_recvN(s,buf,len);
	buf[len]=0; /* C string MUST be nul terminated */
	printf("Client sent data '%s'\n",buf);
	
	skt_close(s);
	skt_close(serv);
	return 0;
}
