/**
Very simple network server.

Orion Sky Lawlor, olawlor@acm.org, 2006/1/22 (Public Domain)
*/
#include <stdio.h>
#include "osl/socket.h"
#include "osl/socket.cpp" /* include body for easy linking */
struct fooHeader {
	Big32 protocol; /* protocol: always 0xF00BA7 */
	Big32 version; /* 1 for latest version */
	Big32 reqLen; /* bytes of request data */
	Big32 optLen; /* bytes of optional data (after request data) */
};

int main(int argc,char *argv[])
{
	char buf[6];
	unsigned int port=1234; /* use 0 to have OS pick a port */
	SERVER_SOCKET serv=skt_server(&port);
	skt_ip_t client_ip; unsigned int client_port;
	SOCKET s=skt_accept(serv,&client_ip,&client_port);
	const char *req="This begins as a very nice little request.  But it's over now.";
	const char *opt="There were options here, but they flew away.";
	
	fooHeader h;
	h.protocol=0xF00BA7; h.version=1; 
	h.reqLen=strlen(req); h.optLen=strlen(opt);  
	skt_sendN(s,&h,sizeof(h));
	skt_sendN(s,req,h.reqLen);
	skt_sendN(s,opt,h.optLen);

	skt_close(s);
	skt_close(serv);
	return 0;
}
