/**
Very simple network client: connects to localhost:1234,
sends a few bytes, and leaves.

5BOrion Sky Lawlor, olawlor@acm.org, 2005/2/8 (Public Domain)
*/
#include <stdio.h>
#include "osl/socket.h"
#include "osl/socket.cpp" /* include body for easy linking */
struct fooHeader {
	Big32 protocol; /* protocol: always 0xF00BA7 */
	Big32 version; /* 1 for latest version */
	Big32 reqLen; /* bytes of request data */
	Big32 optLen; /* bytes of optional data (after request data) */
};
void error_exit(const char *why,int i) {
	printf("Fatal %s: network sent 0x%08x\n",why,i); 
	exit(1);
}
int main(int argc,char *argv[])
{
	skt_ip_t ip=skt_lookup_ip(argv[1]?argv[1]:"localhost");
	SOCKET s=skt_connect(ip,1234,60); 
	
	fooHeader h;
	skt_recvN(s,&h,sizeof(h));
	if (h.protocol!=0xF00BA7) error_exit("protocol mismatch",h.protocol);
	if (h.version!=1) error_exit("version mismatch",h.version);
	unsigned int reqLen=h.reqLen; /* turn lengths into unsigned integers */
	unsigned int optLen=h.optLen;
	/* sanity check lengths before allocating memory */
	if (reqLen>10000) error_exit("request length",reqLen);
	if (optLen>10000) error_exit("option length",optLen);
	byte *req=new byte[reqLen+1];
	byte *opt=new byte[optLen+1];
	skt_recvN(s,req,reqLen);
	skt_recvN(s,opt,optLen);

	req[reqLen]=0; /* nul-terminate strings before printing */
	opt[optLen]=0;
	
	printf("Received %d bytes of request data: \n\t'%s'\n",
		reqLen,req);
	printf("Received %d bytes of option data: \n\t'%s'\n",
		optLen,opt);

	skt_close(s); 
	return 0;
}
