/**
 Binary I/O demonstration: writes out a little-endian
 16 bit file containing the letters of an ASCII string
 times 13.
 
 Orion Sky Lawlor, olawlor@acm.org, 2005/4/21 (Public Domain)
*/
#include <stdio.h>
#include <stdlib.h>

/**
 Data types for binary I/O.
*/
typedef unsigned char byte;

/**
 In memory, this class is 
 always a little-endian 16-bit integer.  
 This class has no alignment restrictions, unlike "int",
 which the compiler may add padding around.
*/
class lil16 {
private:
	/** Storage for the 16-bit integer we describe. */
	byte v[2];
public:
	/// Assign to a lil16 from a regular machine integer.
	void operator=(int i) {
		v[0]=i&0xff;      /* Low 8 bits stored first */
		v[1]=(i>>8)&0xff; /* Then high 8 bits */
	}
	
	/// "Cast-to-int" operator.
	///  This operator allows us to use "lil16" objects
	///    in expressions just like they were regular "int"s.
	///  It reassembles the integer value that our bytes represent:
	///      <low byte (1's place)> <high byte (256's place)>
	inline operator int () const {
		return (v[0])+(v[1]<<8); 
	}
};

int main(int argc,char *argv[])
{
	FILE *f=fopen("problem4.in","wb");
	if (f==NULL) {printf("Can't open input file!\n"); exit(1);}
	lil16 b;
	/* Here's the string to encode in the file: */
	char *c="Wow- nicely done!  Problem complete.\n";
	while (*c) 
	{ /* Read another letter, encode it, and print it out */
		b=(*c)*13;
		fwrite(&b,sizeof(b),1,f);
		c++; /* advance to next letter of string to encode */
	}
	fclose(f);
	printf("Done writing.\n");
	return 0;
}
