/**
 Problem4:
   This problem asks you to perform binary I/O.
   The file you'll be extracting, "problem4.in",
   is strange: it's a series of 16-bit, big-endian 
   byte order integers.  Each integer represents one 
   character, but the value stored is not ASCII-- it's 
   "ASCII times 13".   So this program reads each 
   16-bit value in the file, divides by thirteen, and 
   prints out the resulting ASCII character.
   
   But all x86 machines run in little-endian byte order,
   so we can't just typecast the 16-bit values from the
   file to a "short".  Instead, we've got to read the 
   files as bytes, then reassemble the integer value.
   The "big16" class is set up to do this, but it's missing
   the key "convert to an integer" routine.
   
   Implement this routine, and paste the one-line decoded printout
RIGHT HERE
 
   Orion Sky Lawlor, olawlor@acm.org, 2005/4/21 (Public Domain)
*/
#include <stdio.h>
#include <stdlib.h>

/**
 Data types for binary I/O.
*/
typedef unsigned char byte;

/**
 In memory, this class is 
 always a big-endian 16-bit integer.  
 This class has no alignment restrictions, unlike "int",
 which the compiler may add padding around.
*/
class big16 {
private:
	/** Storage for the 16-bit integer we describe. */
	byte v[2];
public:
	/// Assign to a big16 from a regular machine integer.
	void operator=(int i) {
		v[0]=i&0xff;
		v[1]=(i>>8)&0xff;
	}
	
	/// "Cast-to-int" operator.
	///  This operator allows us to use "big16" objects
	///    in expressions just like they were regular "int"s.
	///  It reassembles the integer value that our bytes represent.
	inline operator int () const {
		return (v[1]<<8)+(v[0]);
	}
};

int main(int argc,char *argv[])
{
	FILE *f=fopen("problem4.in","rb");
	if (f==NULL) {printf("Can't open input file!\n"); exit(1);}
	printf("Decoding:\n");
	big16 b;
	while (1==fread(&b,sizeof(b),1,f)) 
	{ /* We just read another letter.  Now decode and print it out. */
		char decoded=b/13;
		printf("%c ",decoded);
	}
	fclose(f);
	printf("Done reading.\n");
	return 0;
}
