/**
  Problem 3:
     This is a disturbingly common problem.  Let's say you've
     got a big chunk of code, listed here in "main", that doesn't
     work.  It crashes, because of a segfault.  The right way to
     fix this is of course to figure out *why* it's segfaulting,
     and fix the program.  Of course, most times, nobody has any
     idea why it's segfaulting, and your boss just wants it to work.
     
     One very dangerous solution is to just treat a segfault
     as a request for more memory.  That is, when you get a 
     segfault, you should respond by mapping some (zerod, writeable)
     memory in at that spot in memory.  In this problem, I'm asking
     you to do just that-- change "badMem" to map in zero'd memory.  
     
     Once complete, the flaky program in "main" should 
     run to completion, and print out:

2 3 5 7 11 13 65537 65539 65543 65551 196613 262147 262151 262153 327689 589829 655373 720899 720901 786433 851971 917513 917519 
Problem complete!
     
  Orion Sky Lawlor, olawlor@acm.org, 2005/4/15 (Public Domain)
*/
#include <stdio.h>
#include <stdlib.h>
#include "badmemlib.h"
#include "badmemlib.cpp"
#include "mmapfile.h"
#include "mmapfile.cpp"

class myBadMemHandler : public BadMemHandler {
	MMapFile *f;
	int pageSize; // Size of one page, in bytes
	int pagesUsed;
	
public:
	myBadMemHandler(void)
	{
		pageSize=MMapFile::pageSize;
		f=new MMapFile(NULL,MMapFile::readWritePrivate,
			0x0,1000*pageSize);
		pagesUsed=0;
	}
	
	/**
	  Hit a bad memory access: just map in a fresh page there.
	*/
	virtual void badMem(void *atAddress) {
		void *pageStart=(void *)(((char *)atAddress-(char *)0)/pageSize*pageSize);
		printf("Hit bad memory access at address %p (on page %p)\n",
			atAddress,pageStart);
		
		/* Solution: map in new pages, read/write private.
		  On Windows, we must use a different offset each time
		  we map data in, or else the map will fail.
		*/
		f->map(pagesUsed*pageSize,MMapFile::readWritePrivate,
			pageStart,pageSize);
		
		pagesUsed++;
	}
};

int main(int argc,char *argv[]) {
/* Set up our memory fault fixer */
	myBadMemHandler *h=new myBadMemHandler();
	BadMemSetup(h);
	
/* Run the flaky program.
   You MAY NOT CHANGE THIS PROGRAM (assume it's too complicated or confusing)
*/
	printf("About to run flaky program...\n");
	int i,len=1000000;
	int *data=(int *)0x50000000;
	for (i=0;i<len;i++) {
		data[i]=0;
	}
	for (i=2;i<len;i++) 
	if (data[i]==0)
	{
		if (0==(i&0x0fff0)) {printf("%d ",i); fflush(stdout);}
		for (int j=2*i;j<len;j+=i)
			data[j]++;
	}	
	
	printf("\nProblem complete!\n");
	return 0;
}
