/**
  Problem 1:
    This program maps a file ("test.1m") into memory 
    on demand-- when the memory is first accessed, 
    the pagefault handler (the "badMem" routine) maps 
    the data in the file into memory using an "MMapFile"
    object.
    
    The way we've called this works correctly for reading
    the file data, but fails when we try to do writes.  Change the 
    program at the line "NEED SOMETHING ELSE HERE"
    to fix this: set it up so the memory can be changed,
    and any changes can be written back to disk.
    
    Once fixed, the program should print "Survived the 
    write-- Problem Complete!", *and* the file should 
    be changed to start with with 0x58 (ASCII 'X').
  
  Orion Sky Lawlor, olawlor@acm.org, 2005/4/15 (Public Domain)
*/
#include <stdio.h>
#include <stdlib.h>
#include "badmemlib.h"
#include "badmemlib.cpp"
#include "mmapfile.h"
#include "mmapfile.cpp"

char *base_ptr=(char *)0x50000000;

class myBadMemHandler : public BadMemHandler {
	MMapFile *f;
	int len;
	bool isMapped;
public:
	myBadMemHandler(const char *fName) 
	{
		len=1024*1024;
		f=new MMapFile(fName,MMapFile::readWriteShared,
			base_ptr,len);
		isMapped=false;
	}
	
	virtual void badMem(void *atAddress) {
		printf("  Hit bad memory access at address: %p\n",
			atAddress);
		if (!isMapped) 
		{ /* Not already mapped in */
			f->map(0,MMapFile::readOnly,
				base_ptr,len);
			isMapped=true;
		} else { /* Already mapped in, but still got segfault! */
			printf("Already mapped in data.  Unmapping.\n");
			f->unmap(base_ptr,len);
			/* Solution: map the file into memory read/write
			  with shared (written back to file) access. */
			f->map(0,MMapFile::readWriteShared,
				base_ptr,len);
		}
	}
};

int main() {
	myBadMemHandler *h=new myBadMemHandler("test.1m");
	BadMemSetup(h);
	
	printf("About to read from %p\n",base_ptr);
	char c=*base_ptr;
	printf("Value at %p = %d\n",base_ptr,c);
	
	printf("About to write to %p\n",base_ptr);
	*base_ptr=0x58;
	printf("Survived the write-- Problem complete!\n");
	return 0;
}
