/**
  A little library to recieve, and respond to,
  segmentation faults--out of bounds, or bad
  memory accesses.
  
  Orion Sky Lawlor, olawlor@acm.org, 2005/04/15 (Public Domain)
*/
#ifndef __OSL_BADMEMLIB_H
#define __OSL_BADMEMLIB_H

/**
 This class receives and handles 
 bad memory accesses.
*/
class BadMemHandler {
public:
	virtual ~BadMemHandler(); /* for whining compilers */
	
	/**
	  A segmentation fault just occurred, at 
	  this address.  The handler *must* respond by
	  either mapping this address in, or else exiting.
	*/
	virtual void badMem(void *atAddress) =0;
};

/**
  Add a new bad memory handler.
  Returns the previous bad memory handler,
  or NULL if there was no previous handler.
  The library will then call h->badMem on any
  subsequent bad memory accesses.
*/
BadMemHandler *BadMemSetup(BadMemHandler *h);


#endif
