/**
Very simple web server.

Orion Sky Lawlor, olawlor@acm.org, 2005/2/8 (Public Domain)
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pthread.h>
#include "sockRoutines.h"

int usage_count=0;

void serve_client(SOCKET server_fd)
{
	// Connect with the client
	skt_ip_t client_ip; unsigned int client_port;
	SOCKET s=skt_accept(server_fd,&client_ip,&client_port);
	char client_ip_name[100];
	printf("Connection received from %s:%d\n",
		skt_print_ip(client_ip_name,client_ip),client_port);
	
	// Receive the client's request up to the first newline.
	//  This looks like "GET /some/url HTTP/1.1"
	char buf[1000];
	int buflen=0;
	while (1) {
		char c;
		skt_recvN(s,&c,1);
		if (buflen>=999 || c=='\r' || c=='\n') break;
		buf[buflen++]=c;
	}
	buf[buflen++]=0;
	printf("Client request: %s\n",buf);
	
	usage_count++;
	
	
	// Respond to the client's request, by sending him
	//   a web page.
	const char *webPage=
	"HTTP/1.0 200 OK\n"
	"Content-Type: text/html\n"
	"Content-Length: 72\n"
	"\n"
	"<html><title>Foo.</title><body>\n"
	"This is not a web page.\n"
	"</body></html>\n\n";
	skt_sendN(s,webPage,strlen(webPage));
	
	// Close the client socket
	skt_close(s);
}

typedef struct client_serve_struct {
	SOCKET server_fd;
} client_serve_struct;

void *run_client_thread(void *p) {
	client_serve_struct *serv=(client_serve_struct *)p;
	serve_client(serv->server_fd);
	free(serv);
	return 0;
}

int main(int argc,char *argv[])
{
	unsigned int port=8080;
	SOCKET server_fd;
	skt_init();
	server_fd=skt_server(&port);
	while (1) {
		printf("\nWaiting for connect on port %d\n",port);
		// Wait for a client to connect
		skt_select1(server_fd,1000*1000*1000);
		
		{
			pthread_t A;
			pthread_attr_t attr;
			pthread_attr_init(&attr);
			client_serve_struct *serv=(client_serve_struct *)malloc(sizeof(client_serve_struct));
			serv->server_fd=server_fd;
			pthread_create(&A,&attr, run_client_thread,serv);
		}
	}
	return 0;
}

