/**
Very simple web client.

Orion Sky Lawlor, olawlor@acm.org, 2005/2/8 (Public Domain)
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "skt.h"

/** 
  Send this C (null-terminated) string to this network socket.
    Does not send the terminating nul character.
*/
void sendString(SOCKET s,const char *str) {
	skt_sendN(s,str,strlen(str));
}

/**
  Connect to this web server, send the GET request,
  and return a socket to read the web page from.
*/
SOCKET connect_to_URL(const char *url)
{
	char server[1000];
	int port=80;
	/// FIXME: support other URL formats here!
	int nScan=sscanf(url,"http://%999[^:/]:%d",server,&port);
	skt_ip_t ip;
	SOCKET s;
	if (nScan<1) {
		printf("Cannot parse URL '%s'!\n",url);
		exit(1);
	}
	s=skt_connect(skt_lookup_ip(server),port,60);
	sendString(s,"GET ");
	if (0) sleep(10); /* put in a big weird delay */
	sendString(s,url);
	sendString(s," HTTP/1.1\r\nHost: \r\n\r\n");
	/* FIXME: send other HTTP headers here, like Content-Type */
	return s;
}

/*
  Receive a web page from this socket.
*/
void receive_page(SOCKET s) {
	/*
	  FIXME: Receives fixed-size buffer.
	  Should parse HTTP headers, and choose
	  appropriate length!
	*/
#define buflen 128
	char buf[buflen];
	skt_recvN(s,buf,buflen);
	buf[buflen-1]=0;
	printf("Client received:\n%s\n",buf);
}

int main(int argc,char *argv[])
{
	SOCKET s;
	if (argc<=1) {
		printf("usage: webclient <url>\n");
	}
	skt_init();
	s=connect_to_URL(argv[1]);
	receive_page(s);
	return 0;
}

