/*Orion Lawlor's Simple x86 assembly Examples, olawlor@acm.org, 2004/7/29
Shows how to use SSE instructions via xmmintrin.h.
*/
#include <stdio.h>
#include <xmmintrin.h>

volatile float val=1.0;
int main() {
	typedef float sseFloats[4];
	sseFloats a={0.1,0.2,0.3,0.4};
	sseFloats b={3.0,3.0,10.0,10.0};
	__m128 ma=_mm_loadu_ps(&a[0]);
	__m128 mb=_mm_loadu_ps(&b[0]);
	__m128 mprod=_mm_mul_ps(ma,mb);
	sseFloats prod;
	_mm_store_ps(prod,mprod);
	
	printf("Product is (%.2f,%.2f,%.2f,%2.f)\n",
		prod[0],prod[1],prod[2],prod[3]);
	
	/* Unlike MMX, SSE instructions *don't* require an
	   mm_empty afterwards: floating point can be mixed with SSE.
	*/
	float pre_val=val*2.0;
	_mm_empty();
	float post_val=val*2.0;
	printf("Floating-point: before MMX flush: %.2f\n",pre_val);
	printf("Floating-point:  after MMX flush: %.2f\n",post_val);
}
/*<@>
<@> ******** Program output: ********
<@> Product is (0.30,0.60,3.00, 4)
<@> Floating-point: before MMX flush: 2.00
<@> Floating-point:  after MMX flush: 2.00
<@> */
